//
//  B5UserAccountUserOverview.h
//  ApplicationFrameworks
//
//  Created by Michael Fey on 5/9/16.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordDataModel/B5DatabaseObject.h>
#include <stdint.h>

typedef NS_OPTIONS (uint64_t, B5UserPermission) {
	// Group membership
	B5UserPermissionBelongsToTeamMembersGroup = (uint64_t)1 << 0, // Fixed flag set only on the TeamMembers group
	B5UserPermissionBelongsToOwnersGroup      = (uint64_t)1 << 1, // Fixed flag set only on the Owners group
	B5UserPermissionBelongsToAdminsGroup      = (uint64_t)1 << 2, // Fixed flag set only on the Admin group
	B5UserPermissionBelongsToRecoveryGroup    = (uint64_t)1 << 3, // Fixed flag set only on the Recovery group
	B5UserPermissionBelongsToUserDefinedGroup = (uint64_t)1 << 4, // Fixed flag set only on the User Defined groups

	// Permissions
	B5UserPermissionRecover            = (uint64_t)1 << 8,
	B5UserPermissionViewAdminConsole   = (uint64_t)1 << 9,  // Show the admin console on the client
	B5UserPermissionViewActivities     = (uint64_t)1 << 10, // Show activity log

	B5UserPermissionViewPeople         = (uint64_t)1 << 12, // Show the people list and person details in the admin console
	B5UserPermissionAddPerson          = (uint64_t)1 << 13,
	B5UserPermissionChangePersonName   = (uint64_t)1 << 14,
	B5UserPermissionSuspendPerson      = (uint64_t)1 << 15,
	B5UserPermissionDeletePerson       = (uint64_t)1 << 16,
	B5UserPermissionViewVaults         = (uint64_t)1 << 17, // Show the vault list in the admin console
	B5UserPermissionUsePersonalVault   = (uint64_t)1 << 18, // Allow users to see and use their personal/private vaults
	B5UserPermissionAddVault           = (uint64_t)1 << 19,
	B5UserPermissionDeleteVault        = (uint64_t)1 << 20,
	B5UserPermissionManageVaults       = (uint64_t)1 << 21, // Can give other users access to shared vaults, change user-vault B5UserPermissions, revoke access
	B5UserPermissionViewGroups         = (uint64_t)1 << 22, // Show the group list in the admin console
	B5UserPermissionManageGroups       = (uint64_t)1 << 23,
	B5UserPermissionViewTeamSettings   = (uint64_t)1 << 24, // Show the settings tab in admin console
	B5UserPermissionChangeTeamSettings = (uint64_t)1 << 25,
	B5UserPermissionChangeTeamAttrs    = (uint64_t)1 << 26,
	B5UserPermissionChangeTeamDomain   = (uint64_t)1 << 27,
	B5UserPermissionSuspendTeam        = (uint64_t)1 << 28,
	B5UserPermissionDeleteTeam         = (uint64_t)1 << 29,
	B5UserPermissionViewBilling        = (uint64_t)1 << 30, // Show the billing menu in the admin console
	
	// Starting at the 32nd bit you have to cast as 64 bits to avoid 32-bit signing issues
	B5UserPermissionManageBilling      = (uint64_t)1 << 31
};

@interface B5UserAccountUserOverview : B5DatabaseObject

- (instancetype)initWithID:(OPID)userOverviewID permissions:(B5UserPermission)permissions;

@property (nonatomic, readonly) B5UserPermission accountPermissions;

@end
